unit ndscreat;

interface

uses
  {$IFDef Win32}
  Windows, 
  {$ENDIF}
  Messages, 
  SysUtils, 
  Classes, 
  Graphics, 
  Controls, 
  Forms, 
  Dialogs, 
  StdCtrls, 
  ExtCtrls, 
  Nwlib, 
  Nwnds, 
  Buttons, 
  Nwtools;

type
  TwinNDSCreate = class(TForm)
    objectName: TEdit;
    first: TEdit;
    middle: TEdit;
    last: TEdit;
    objTypeBox: TRadioGroup;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    saveBtn: TBitBtn;
    cancelBtn: TBitBtn;
    Label2: TLabel;
    context: TEdit;
    Label7: TLabel;
    objPassword: TEdit;
    procedure saveBtnClick(Sender: TObject);
    procedure objPasswordExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var                                                               
  winNDSCreate: TwinNDSCreate;

implementation

{$R *.DFM}

procedure TwinNDSCreate.FormShow(Sender: TObject);
  begin
    context.text := '' ; {ndsGetContextName ;}
  end;

procedure TwinNDSCreate.objPasswordExit(Sender: TObject);
  begin
    objPassword.passwordChar := '*' ;
  end;

procedure TwinNDSCreate.saveBtnClick(Sender: TObject);
  var
    ndsObjInfo : TNWDSObjectInfo ;
  begin
    if (not yesNoBox('Saving NDS Object;;Are You Sure?')) then
      exit ;
    with ndsObjInfo do begin
      cn          := first.text[1] + last.text ;  {common name}
      contextName := context.text ;
      objName     := objectName.text;
      surname     := last.text;
      givenName   := first.text ;
      fullName    := lTrim(last.text + ' ') + 
                     lTrim(middle.text + ' ') + 
                     first.text ;
      password    := objPassword.text ;
      objType     := dsoUser ;
      case objTypeBox.itemIndex of
        0: objType := dsoUser ;
        1: objType := dsoOrganizationalUnit ;
        2: objType := dsoOrganization ;
        3: objType := dsoPrintServer ;
        4: objType := dsoPrinter ;
        5: objType := dsoQueue ;
      end ;  
    end;  
    if ndsCreateObject(ndsObjInfo) then
      begin
        okBox(ndsObjInfo.objName + ';;Created Successfully') ;
        modalResult := mrOK ;
      end  
    else
      alertBox('Error Creating NDS Object;;Check Your Access Rights!') ;
  end;

end.
 